
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Jul 23 07:42:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version KMNG_ATP_TST_main.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/************* Include Files **************************************/
#include "DX_VOS_Stdio.h"
#include "DX_VOS_Utils.h"
#include "DX_VOS_File.h"
#include "KMNG_ATP_TST_Defines.h"
#include "KMNG_ATP_TST_ManageOp.h"
#include "KMNG_ATP_TST_KeysOp.h"
#include "KMNG_TST_Utils.h"
#include "MW_ATP_define_flags.h"
#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"
#include "KMNG_API.h"

/************************ Defines **********************************/
extern DxError_t KMNG_ATP_menu(void);
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/
#if KMNG_TST_LOG_ENABLE 
DxVosFile  TST_main_log;
char      *TST_KMNG_log_fname_ptr = DX_NULL;
#endif

/************************ Public Functions *************************/

 #if KMNG_QA_ATP_TST

 int main(int argc, char *argv[])

 #else

 DxStatus KMNG_ATP_TST_main (int argc, char *argv[])

 #endif  /* KMNG_QA_ATP_TST */
 {
    /********* TST Variables Definitions ************/
    DxError_t           TST_Status = DX_SUCCESS;
   
/*
#if KMNG_TST_LOG_ENABLE
    TST_main_log = DX_NULL; 
    TST_KMNG_log_fname_ptr = argv[1];
    TST_Result = DX_VOS_FOpen(&TST_main_log, TST_KMNG_log_fname_ptr ,"w+");
    if (TST_Result != DX_SUCCESS)
    {
      DX_VOS_Printf("CANT OPEN LOG FILE \n");      
      return KMNG_TEST_FAIL;
    }
#endif*/

    /* Handle Command Line Arguments */
    TST_Status = MW_ATP_UTIL_ParseArgs(argc,argv);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "MW_ATP_UTIL_ParseArgs",
                               "!!!!!!!!!",
                               "!!!!!!!!!");

    /* Init CRYS */
    TST_Status = MW_ATP_UTIL_Init_CRYS();
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "MW_ATP_UTIL_Init_CRYS",
                               "!!!!!!!!!",
                               "!!!!!!!!!");

    /* Start KMNG_ATP and its Menu */
    TST_Status = KMNG_ATP_menu();
    
    
    #if KMNG_TST_LOG_ENABLE
    DX_VOS_FClose(TST_main_log);
    #endif
    return 0;
    EXIT_ON_ERROR:
    {
      return DX_FAILURE;
    }
 }/* End of KMNG_ATP_TST_main*/

